Imports MicroFour.StrataFrame.Tools
Imports System.Web.Configuration
Imports CommonBusiness

Public Class ApplicationBasePage
    Inherits MicroFour.StrataFrame.UI.Web.BasePage
    Implements MicroFour.StrataFrame.Tools.ITypeResolver

#Region " Business Object Declarations "

	'-- Business Objects defined within this class will be available to 
	'   inherited pages as binding sources to bindable controls.  These 
	'   business objects will also be persisted within session variables 
	'   and retrieved each time the page loads.  If the business object 
	'   is declared WithEvents, events can be handled without the need 
    '   for AddHandler calls.
    Public WithEvents Customers As CustomersBO
        
#End Region

#Region " ITypeResolver Implementation "

    ''' <summary>
    ''' Must be used by the StrataFrame Application Framework to resolve a type 
    ''' within this ASP.NET project due to the fact that the Entry Assembly 
    ''' cannot be evaluated in an ASP.NET application
    ''' </summary>
    ''' <param name="TypeName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ResolveType(ByVal TypeName As String) As Type Implements ITypeResolver.ResolveType
        '-- Return the gettype for the given TypeName
        Return Type.GetType(TypeName, False, True)
    End Function
    
	''' <summary>
    ''' Returns the configuration section to the base class allowing the StrataFrame 
    ''' Application Framework to access the assemblies referenced by this project.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetCompilationSection() As CompilationSection Implements ITypeResolver.GetCompilationSection
        Return WebConfigurationManager.GetSection("system.web/compilation")
    End Function

#End Region

#Region " Handled Events "

    Private Sub Page_PreRender1(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.PreRender
        Me.ErrorIcon = "images/brokenrule.gif"
    End Sub

#End Region

#Region " Common Methods "

    ''' <summary>
    ''' Generates a warning table
    ''' </summary>
    ''' <param name="WarningText"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GenerateWarningTable(ByVal WarningText As String) As String
        '-- Establish Locals
        Dim lcReturn As String = "<table cellspacing='0' cellpadding='2' class='ErrorTable'><tr><td class='ErrorImageCell'><img src='images/warning_error.gif'</td><td class='ErrorTextCell'>"

        '-- Add the text to the warning table
        lcReturn &= WarningText & "</td></tr></table>"

        '-- Return the table
        Return lcReturn
    End Function

#End Region
    
End Class